import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    RentalRetireeDocumentPreviewItem,
    RentalRetireeDocumentPreviewItemProps,
} from 'features/RentalRetiree/ui/RentalRetireeDocumentPreviewItem/RentalRetireeDocumentPreviewItem';

const storybookMeta = createStorybookMeta<RentalRetireeDocumentPreviewItemProps>({
    title: 'features/RentalRetiree/RentalRetireeDocumentPreviewItem',
    component: RentalRetireeDocumentPreviewItem,

    parameters: { backgrounds: { default: 'white' } },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<RentalRetireeDocumentPreviewItemProps>(RentalRetireeDocumentPreviewItem);

// @todo: add normal state with blob base64 response
export const empty = Template.bind({});
empty.args = {
    type: 'ps',
    userId: '5f6dd26c-5b52-47f6-ad27-74e73e41e7a8',
    photoId: '38b71151-5007-6df6-9ee5-a41762984919',
};

export const loading = Template.bind({});
loading.args = {
    type: 'pb',
    userId: '5f6dd26c-5b52-47f6-ad27-74e73e41e7a8',
    photoId: '48b71151-5007-6df6-9ee5-a41762984919',
};
