import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '1 of 4. Upload driver’s documents': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '1 of 4. Upload driver’s documents',
        ru: '1 из 4. Загрузите документы водителя',
        cs: '1 ze 4. Nahrajte dokumenty řidiče',
    },
    Confirm: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Confirm',
        ru: 'Подтвердить',
        cs: '',
    },
    'Driver’s license': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Driver’s license',
        ru: 'Водительские права',
        cs: 'Řidičský průkaz',
    },
    'Passport/ID card': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Passport/ID card',
        ru: 'Паспорт/ID карта',
        cs: '',
    },
    'Save documents and verify user': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Save documents and verify user',
        ru: 'Сохранить документы и подтвердить пользователя',
        cs: '',
    },
    'Saving documents...': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Saving documents...',
        ru: 'Сохранение документов...',
        cs: '',
    },
    'Starting the ride manually': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Starting the ride manually',
        ru: 'Запуск поездки вручную',
        cs: 'Ruční spuštění jízdy',
    },
    'Uploading document photos...': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Uploading document photos...',
        ru: 'Загрзка фотографий документов...',
        cs: '',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
