import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { modalScrollState } from 'tests/storybook/helpers/modalScrollState';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    RentalRetireeDocumentsModal,
    RentalRetireeDocumentsModalProps,
} from 'features/RentalRetiree/ui/RentalRetireeDocumentsModal/RentalRetireeDocumentsModal';

const storybookMeta = createStorybookMeta<RentalRetireeDocumentsModalProps>({
    title: 'features/RentalRetiree/RentalRetireeDocumentsModal',
    component: RentalRetireeDocumentsModal,

    hermioneSelector: '[role="dialog"]',

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<RentalRetireeDocumentsModalProps>((props) => (
    <RentalRetireeDocumentsModal {...props} />
));

export const normal = Template.bind({});
normal.args = { userId: '5f6dd26c-5b52-47f6-ad27-74e73e41e7a8' };
normal.hermionePlainFn = modalScrollState;

export const empty = Template.bind({});
empty.args = { userId: '54331194-9054-4d49-b2f9-7b5c591c9aa2' };
empty.hermionePlainFn = modalScrollState;
