import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{value} km': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: '{value} km',
        ru: '{value} км',
        cs: '{value} km',
    },
    'Confirm and finish': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Confirm and finish',
        ru: 'Подтвердить и завершить',
        cs: 'Potvrďte a dokončete',
    },
    'Confirm the finish of the ride': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Confirm the finish of the ride',
        ru: 'Подтвердите завершение поездки',
        cs: 'Potvrďte dokončení jízdy',
    },
    'Date and place': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Date and place',
        ru: 'Дата и место',
        cs: 'Datum a místo',
    },
    'Duration: {value}': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Duration: {value}',
        ru: 'Длительность: {value}',
        cs: 'Doba trvání: {value}',
    },
    Finish: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Finish',
        ru: 'Завершение',
        cs: 'Ukončit',
    },
    'Finishing ride...': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Finishing ride...',
        ru: 'Завершение поездки...',
        cs: '',
    },
    Fuel: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Fuel',
        ru: 'Топливо',
        cs: 'Stav nádrže',
    },
    'Limit: {value}': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Limit: {value}',
        ru: 'Лимит: {value}',
        cs: '',
    },
    'Mileage: {value}': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Mileage: {value}',
        ru: 'Пробег: {value}',
        cs: 'Počet ujetých kilometrů: {value}',
    },
    Odometer: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Odometer',
        ru: 'Одометр',
        cs: 'Tachometer',
    },
    'Overmileage: {value}': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Overmileage: {value}',
        ru: 'Перепробег: {value}',
        cs: 'Počet ujetých kilometrů nad limit: {value}',
    },
    Parameter: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'EXPIRED',
            },
        },
        en: 'Parameter',
        ru: 'Значение',
        cs: 'Parametr',
    },
    'Photos of car': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Photos of car',
        ru: 'Фотографии автомобиля',
        cs: 'Fotky auta',
    },
    Start: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Start',
        ru: 'Начало',
        cs: 'Začatek',
    },
    'Uploading photos...': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Uploading photos...',
        ru: 'Загрузка фотографий...',
        cs: '',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
