import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    RentalRetireeFinishRideModal,
    RentalRetireeFinishRideModalProps,
} from 'features/RentalRetiree/ui/RentalRetireeFinishRideModal/RentalRetireeFinishRideModal';

const storybookMeta = createStorybookMeta<RentalRetireeFinishRideModalProps>({
    title: 'features/RentalRetiree/RentalRetireeFinishRideModal',
    component: RentalRetireeFinishRideModal,

    hermioneSelector: '[role="dialog"]',

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<RentalRetireeFinishRideModalProps>(RentalRetireeFinishRideModal);

export const normal = Template.bind({});
normal.args = { offerId: '7782e07c-8c01-68a6-6b24-e50f26e8238a' };
normal.hermioneFn = async (browser, selector) => {
    await browser.$('[title="Confirm and finish"]').click();
    await browser.$('[role="alert"]').waitForDisplayed();

    await browser.assertView('withError', selector);
};

export const withLimit = Template.bind({});
withLimit.args = { offerId: '7782e07c-8c01-68a6-6b24-e50f26e8238b' };
