import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{status} unpaid': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: '{status} unpaid',
        ru: '{status} и не оплачено',
        cs: '',
    },
    '3 of 4. Check the payment': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '3 of 4. Check the payment',
        ru: '3 из 4. Проверьте оплату',
        cs: '3 ze 4. Zkontrolujte platbu',
    },
    '3 of 4. Payment': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '3 of 4. Payment',
        ru: '3 из 4. Оплата',
        cs: '3 ze 4. Platba',
    },
    Deposit: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Deposit',
        ru: 'Депозит',
        cs: 'Záloha',
    },
    Insurance: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Insurance',
        ru: 'Страхование',
        cs: 'Pojištění',
    },
    'Mark as paid and start inspection': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Mark as paid and start inspection',
        ru: 'Отметить как оплачен и начать приемку',
        cs: '',
    },
    Options: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Options',
        ru: 'Опции',
        cs: 'Možnosti',
    },
    'Start inspection': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Start inspection',
        ru: 'Начать приемку',
        cs: '',
    },
    'Starting inspection...': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Starting inspection...',
        ru: 'Начало приемки...',
        cs: '',
    },
    'Starting the ride manually': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Starting the ride manually',
        ru: 'Запуск поездки вручную',
        cs: 'Ruční spuštění jízdy',
    },
    Status: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Status',
        ru: 'Статус',
        cs: 'Stav',
    },
    'Total for {value}': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Total for {value}',
        ru: 'Всего за {value}',
        cs: '',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
