import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    RentalRetireePaymentModal,
    RentalRetireePaymentModalProps,
} from 'features/RentalRetiree/ui/RentalRetireePaymentModal/RentalRetireePaymentModal';

const storybookMeta = createStorybookMeta<RentalRetireePaymentModalProps>({
    title: 'features/RentalRetiree/RentalRetireePaymentModal',
    component: RentalRetireePaymentModal,

    hermioneSelector: '[role="dialog"]',

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<RentalRetireePaymentModalProps>(RentalRetireePaymentModal);

export const draft = Template.bind({});
draft.args = { offerId: '90ff257f-4132-5214-2e94-cc5024aedf02' };

export const confirmed = Template.bind({});
confirmed.args = { offerId: '149ca8c4-6276-3fcc-0bd3-e334cd410bc5' };

export const paid = Template.bind({});
paid.args = { offerId: '090cb78c-b91e-b814-f538-cf8323ba2036' };
paid.hermioneFn = async (browser, selector) => {
    await browser.$('[title="Start inspection"]').click();
    await browser.$('[role="alert"]').waitForDisplayed();

    await browser.assertView('withError', selector);
};
