import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{value} km': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: '{value} km',
        ru: '{value} км',
        cs: '{value} km',
    },
    '4 of 4. Check the data, upload the car photos and start the ride': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '4 of 4. Check the data, upload the car photos and start the ride',
        ru: '4 из 4. Проверьте данные, загрузите фотографии автомобиля и начните поездку',
        cs: '4 ze 4. Zkontrolujte údaje, nahrajte fotografie vozidla a začněte jízdu',
    },
    'Date and place': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Date and place',
        ru: 'Дата и место',
        cs: 'Datum a místo',
    },
    Fuel: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Fuel',
        ru: 'Топливо',
        cs: 'Stav nádrže',
    },
    Odometer: {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Odometer',
        ru: 'Одометр',
        cs: 'Tachometer',
    },
    'Photos of car': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Photos of car',
        ru: 'Фотографии автомобиля',
        cs: 'Fotky auta',
    },
    'Start ride': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Start ride',
        ru: 'Начать поездку',
        cs: 'Začněte jízdu',
    },
    'Starting ride...': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Starting ride...',
        ru: 'Начало поездки...',
        cs: '',
    },
    'Starting the ride manually': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Starting the ride manually',
        ru: 'Запуск поездки вручную',
        cs: 'Ruční spuštění jízdy',
    },
    'Uploading photos...': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Uploading photos...',
        ru: 'Загрузка фотографий...',
        cs: '',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
