import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    RentalRetireeStartRideModal,
    RentalRetireeStartRideModalProps,
} from 'features/RentalRetiree/ui/RentalRetireeStartRideModal/RentalRetireeStartRideModal';

const storybookMeta = createStorybookMeta<RentalRetireeStartRideModalProps>({
    title: 'features/RentalRetiree/RentalRetireeStartRideModal',
    component: RentalRetireeStartRideModal,

    hermioneSelector: '[role="dialog"]',

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<RentalRetireeStartRideModalProps>(RentalRetireeStartRideModal);

export const normal = Template.bind({});
normal.args = { offerId: '7782e07c-8c01-68a6-6b24-e50f26e8238a' };
normal.hermioneFn = async (browser, selector) => {
    await browser.$('[title="Start ride"]').click();
    await browser.$('[role="alert"]').waitForDisplayed();

    await browser.assertView('withError', selector);
};
