import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Save as report': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Save as report',
        ru: 'Сохранить как отчет',
        cs: 'Uložit jako výkaz',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
