import * as React from 'react';
import { useState } from 'react';

import { ReportSection } from 'entities/Report/consts/ReportSection';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { Button } from 'shared/ui/Button/Button';

import { CarsFiltersOptions } from 'components/Cars';
import ReportModal from 'components/Reports/ReportModal';
import { RidesFiltersOptions } from 'components/Rides';
import { SignalsFiltersOptions } from 'components/Signals';

import { i18n } from 'features/SaveReport/ui/SaveReport/SaveReport.i18n';

import ReportIcon from 'shared/ui/Icons/images/bookmark-outline-16.inline.svg';

export interface SaveReportProps {
    className?: string;
    section: ReportSection;
    filters: CarsFiltersOptions | RidesFiltersOptions | SignalsFiltersOptions;
}

export const SaveReport: React.FC<SaveReportProps> = function SaveReport({ className, section, filters }) {
    const [isModalOpen, setModalOpen] = useState<boolean>(false);

    const onButtonClickHandler = React.useCallback(() => {
        setModalOpen(true);
    }, []);

    const onModalCloseHandler = React.useCallback(() => {
        setModalOpen(false);
    }, []);

    return (
        <>
            <Button
                className={className}
                color={ButtonColor.SECONDARY}
                size={ButtonSize.M}
                icon={ReportIcon}
                label={i18n('Save as report')}
                onClick={onButtonClickHandler}
            />

            {isModalOpen && (
                <ReportModal
                    section={section}
                    filterValues={filters}
                    onClose={onModalCloseHandler}
                />
            )}
        </>
    );
};
