import { SettingsRatesFormSchema } from 'features/SettingsDailyRates/types/SettingsRatesFormSchema';

import { postCarOfferPricing } from 'entities/Car/api/postCarOfferPricing/postCarOfferPricing';
import { CAR_OFFER_PRICING_SEP } from 'entities/Car/consts/constants';
import { CarOfferPricingReportSchema } from 'entities/Car/types/CarOfferPricingReportSchema';

export function postSettingsRatesForm(data: SettingsRatesFormSchema, prev: CarOfferPricingReportSchema) {
    const grid = JSON.parse(JSON.stringify(prev.action_meta.economy.grid));

    Object.keys(data).forEach((item) => {
        const [range, rate] = item.split(CAR_OFFER_PRICING_SEP);

        const rangeIndex = grid.findIndex((item) => item.id === range);
        const rates = grid[rangeIndex].tariff_costs;
        const rateIndex = rates.findIndex((item) => item.id === rate);

        rates[rateIndex].daily_cost = data[item] ? Number(data[item]) : undefined;
    });

    const next = {
        ...prev,
        action_meta: { ...prev.action_meta, economy: { ...prev.action_meta.economy, migration: { grid } } },
    };

    return postCarOfferPricing(next);
}
