import { RANGE_INT_MAX } from 'features/SettingsDailyRates/consts/constants';

import { CarOfferPricingSchema } from 'entities/Car/types/CarOfferPricingSchema';

import { formatDay } from 'shared/helpers/formatDay/formatDay';

export function formatSettingRatesRanges(ranges: CarOfferPricingSchema['ranges']): Dict {
    let result = {};

    ranges.map(({ id, end }, index) => {
        if (index === 0) {
            result[id] = formatDay({ value: `1–${end}`, count: end });
        } else if (end === RANGE_INT_MAX) {
            const count = ranges[index - 1].end;

            result[id] = formatDay({ value: `${count}+`, count });
        } else {
            const prevCount = ranges[index - 1].end;

            result[id] = formatDay({ value: `${prevCount}–${end}`, count: end });
        }
    });

    return result;
}
