import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    SettingsDailyRates,
    SettingsDailyRatesProps,
} from 'features/SettingsDailyRates/ui/SettingsDailyRates/SettingsDailyRates';

import { useCarOfferPricing } from 'entities/Car/api/useCarOfferPricing/useCarOfferPricing';

const storybookMeta = createStorybookMeta<SettingsDailyRatesProps>({
    title: 'features/SettingsDailyRates/SettingsDailyRates',
    component: SettingsDailyRates,

    parameters: {
        backgrounds: { default: 'white' },
    },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<SettingsDailyRatesProps>((props) => {
    const pricingResource = useCarOfferPricing();

    return (
        <SettingsDailyRates
            {...props}
            resource={pricingResource}
        />
    );
});

export const normal = Template.bind({});

export const empty = Template.bind({});
empty.args = {
    storybookWidth: '90vw',
    storybookHeight: '90vh',
};
empty.parameters = {
    cacheName: 'empty',
};
