import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { minWidthState } from 'tests/storybook/helpers/minWidthState';

import {
    SettingsDailyRatesForm,
    SettingsDailyRatesFormProps,
} from 'features/SettingsDailyRates/ui/SettingsDailyRatesForm/SettingsDailyRatesForm';

const storybookMeta = createStorybookMeta<SettingsDailyRatesFormProps>({
    title: 'features/SettingsDailyRates/SettingsDailyRatesForm',
    component: SettingsDailyRatesForm,

    parameters: {
        backgrounds: { default: 'white' },
    },

    args: {
        title: 'Default rates',
        description: 'Common rule for the whole year',
        rows: [
            {
                id: 'comfort',
                label: 'Comfort with automatic transmission',
                info: 37,
            },
            {
                id: 'economy',
                label: 'Economy with manual transmission',
                info: 23,
            },
            {
                id: 'lux',
                label: 'Lux with automatic transmission',
                info: 10,
            },
        ],
        ranges: {
            '1-3_days': '1–3 days',
            '4-7_days': '3–7 days',
            '8-14_days': '7–14 days',
            '14-30_days': '14–30 days',
            max: '30+ days',
        },
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<SettingsDailyRatesFormProps>(SettingsDailyRatesForm);

export const normal = Template.bind({});
normal.hermioneFn = minWidthState;

export const withCurrency = Template.bind({});
withCurrency.args = { currency: 'CZK' };
