import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    General: {
        en: 'General',
        ru: 'Общее',
        cs: '',
    },
    Notifications: {
        en: 'Notifications',
        ru: 'Уведомления',
        cs: '',
    },
    Pricing: {
        en: 'Pricing',
        ru: 'Расценка',
        cs: '',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
