import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    SettingsHeaderTabs,
    SettingsHeaderTabsProps,
} from 'features/SettingsHeaderTabs/ui/SettingsHeaderTabs/SettingsHeaderTabs';

const storybookMeta = createStorybookMeta<SettingsHeaderTabsProps>({
    title: 'features/SettingsHeaderTabs/SettingsHeaderTabs',
    component: SettingsHeaderTabs,

    decorators: [withStorybookRouter()],
});

export default storybookMeta;

const Template = createStorybookTemplate<SettingsHeaderTabsProps>(SettingsHeaderTabs);

export const empty = Template.bind({});
empty.hermioneSelector = 'html';

export const withPricing = Template.bind({});
withPricing.parameters = { flags: { settings_pricing: true } };

export const withNotification = Template.bind({});
withNotification.parameters = { flags: { showNotificationPage: true } };

export const full = Template.bind({});
full.parameters = { flags: { settings_pricing: true, showNotificationPage: true } };
