import * as React from 'react';

import { SignalMediaDetailsItemSchema } from 'entities/Signal/types/SignalMediaDetailsSchema';

export type VideoAttributes = JSX.IntrinsicElements['video'];

export interface SignalDetailsMediaPlayerProps extends VideoAttributes {
    className?: string;
    video?: SignalMediaDetailsItemSchema;
    photo?: SignalMediaDetailsItemSchema;
}

export const SignalDetailsMediaPlayer: React.FC<SignalDetailsMediaPlayerProps> = React.memo(
    React.forwardRef<HTMLVideoElement, SignalDetailsMediaPlayerProps>(function SignalDetailsMediaPlayer(
        { className, video, photo, ...videoParams },
        ref,
    ) {
        if (!video && !photo) {
            return null;
        }

        return (
            <div className={className}>
                {video ? (
                    <video
                        key={video.presigned_url.link}
                        ref={ref}
                        {...videoParams}
                    >
                        <source
                            src={video.presigned_url.link}
                            type="video/mp4"
                        />
                    </video>
                ) : (
                    <img src={photo!.presigned_url.link} />
                )}
            </div>
        );
    }),
);
