import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { buildDummyImageInline } from 'tests/storybook/helpers/buildDummyImageInline';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    SignalDetailsModal,
    SignalDetailsModalProps,
} from 'features/SignalDetails/ui/SignalDetailsModal/SignalDetailsModal';

const storybookMeta = createStorybookMeta<SignalDetailsModalProps>({
    title: 'features/SignalDetails/SignalDetailsModal',
    component: SignalDetailsModal,

    hermioneSelector: '[role="dialog"]',

    hermioneOptions: { ignoreElements: ['[data-testid="map"]', '[data-testid="address"]'] },

    decorators: [withStorybookRouter()],

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<SignalDetailsModalProps>(SignalDetailsModal);

export const normal = Template.bind({});
normal.args = {
    signal: {
        car: {
            object_id: 'b117c95e-ba83-d98c-28a8-b64d6f9e9b68',
            details: {
                model: 'honda x',
                number: '777K7',
            },
        },
        description: {
            display_name: 'Быстро едешь',
            priority: 'normal',
        },
        since: new Date('2022-01-01T09:00:00'),
    },
};

export const camera = Template.bind({});
camera.args = {
    signal: {
        car: {
            object_id: 'b117c95e-ba83-d98c-28a8-b64d6f9e9b68',
            details: {
                model: 'honda x',
                number: '777K7',
            },
        },
        trace: {
            details: {
                since: new Date('2022-01-01T09:00:00'),
                until: new Date('2022-02-01T09:00:00'),
            },
        },
        description: {
            display_name: 'Быстро едешь',
            priority: 'normal',
        },
        details: {
            media: {
                photo: {
                    presigned_url: {
                        link: buildDummyImageInline({
                            width: 900,
                            height: 300,
                            patternSize: 32,
                            color: '#ff0',
                        }),
                    },
                },
            },
        },
        since: new Date('2022-01-01T09:00:00'),
    },
};

export const cameraDouble = Template.bind({});
cameraDouble.args = {
    signal: {
        car: {
            object_id: 'b117c95e-ba83-d98c-28a8-b64d6f9e9b68',
            details: {
                model: 'honda x',
                number: '777K7',
            },
        },
        description: {
            display_name: 'Быстро едешь',
            priority: 'critical',
            type: 'car_changed_mileage_signal',
        },
        is_actual: true,
        details: {
            media: {
                photo: {
                    presigned_url: {
                        link: buildDummyImageInline({
                            width: 900,
                            height: 300,
                            patternSize: 32,
                            color: '#ff0',
                        }),
                    },
                },
                external_photo: {
                    presigned_url: {
                        link: buildDummyImageInline({
                            width: 900,
                            height: 300,
                            patternSize: 32,
                            color: '#f00',
                        }),
                    },
                },
            },
        },
        since: new Date('2022-01-01T09:00:00'),
    },
};
