import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Geofences: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Geofences',
        ru: 'Зоны',
        cs: 'Zóny',
    },
    Settings: {
        _meta: {
            context: 'Signals settings',
            group: '1',
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Settings',
        ru: 'Настройка',
        cs: 'Nastavení',
    },
    Signals: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signals',
        ru: 'Сигналы',
        cs: 'Signály',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
