import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Car: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car',
        ru: 'Машина',
        cs: 'Vůz',
    },
    'Date and time': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Date and time',
        ru: 'Дата и время',
        cs: 'Datum a čas',
    },
    'Duration, min': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Duration, min',
        ru: 'Продолжительность, мин',
        cs: 'Doba trvání, min',
    },
    Level: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Level',
        ru: 'Уровень',
        cs: 'Úroveň',
    },
    'No signals to display': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'No signals to display',
        ru: 'Нет сигналов для отображения',
        cs: 'Žádné signály k zobrazení',
    },
    Ride: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Ride',
        ru: 'Поездка',
        cs: 'Jízda',
    },
    'Show more': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Show more',
        ru: 'Показать ещё',
        cs: 'Zobrazit více',
    },
    Signal: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signal',
        ru: 'Сигнал',
        cs: 'Signál',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
