import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { buildDummyImageInline } from 'tests/storybook/helpers/buildDummyImageInline';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { SignalsTableRow, SignalsTableRowProps } from 'features/SignalsTable/ui/SignalsTableRow/SignalsTableRow';

const storybookMeta = createStorybookMeta<SignalsTableRowProps>({
    title: 'features/SignalsTable/SignalsTableRow',
    component: SignalsTableRow,

    decorators: [withStorybookRouter()],
});

export default storybookMeta;

const Template = createStorybookTemplate<SignalsTableRowProps>(SignalsTableRow);

export const normal = Template.bind({});
normal.args = {
    signal: {
        car: {
            object_id: 'b117c95e-ba83-d98c-28a8-b64d6f9e9b68',
            details: {
                model: 'honda x',
                number: '777K7',
            },
        },
        trace: {
            details: {
                since: new Date('2022-01-01T09:00:00'),
                until: new Date('2022-02-01T09:00:00'),
            },
        },
        description: {
            display_name: 'Быстро едешь',
            priority: 'normal',
            type: 'car_changed_mileage_signal',
        },
        is_actual: true,
        since: new Date('2022-01-01T09:00:00'),
    },
};
normal.hermioneFn = hoverState;

export const critical = Template.bind({});
critical.args = {
    signal: {
        car: {
            object_id: 'b117c95e-ba83-d98c-28a8-b64d6f9e9b68',
            details: {
                model: 'honda x',
                number: '777K7',
            },
        },
        trace: {
            details: {
                since: new Date('2022-01-01T09:00:00'),
                until: new Date('2022-02-01T09:00:00'),
            },
        },
        description: {
            display_name: 'Быстро едешь',
            priority: 'critical',
            type: 'car_changed_mileage_signal',
            is_permanent: true,
        },
        details: {
            media: {
                photo: {
                    presigned_url: {
                        link: buildDummyImageInline({
                            width: 96,
                            height: 72,
                            patternSize: 32,
                            color: '#ff0',
                        }),
                    },
                },
            },
        },
        since: new Date('2022-01-01T09:00:00'),
    },
};

export const criticalActual = Template.bind({});
criticalActual.args = {
    signal: {
        car: {
            object_id: 'b117c95e-ba83-d98c-28a8-b64d6f9e9b68',
            details: {
                model: 'honda x',
                number: '777K7',
            },
        },
        trace: {
            details: {
                since: new Date('2022-01-01T09:00:00'),
                until: new Date('2022-02-01T09:00:00'),
            },
        },
        description: {
            display_name: 'Быстро едешь',
            priority: 'critical',
            type: 'car_changed_mileage_signal',
        },
        is_actual: true,
        details: {
            media: {
                photo: {
                    presigned_url: {
                        link: buildDummyImageInline({
                            width: 96,
                            height: 72,
                            patternSize: 32,
                            color: '#ff0',
                        }),
                    },
                },
                video: {
                    presigned_url: {
                        link: 'some-url',
                    },
                },
            },
        },
        since: new Date('2022-01-01T09:00:00'),
    },
};
