import { deleteCarTag } from 'entities/Car/api/deleteCarTag/deleteCarTag';
import { postCarTag } from 'entities/Car/api/postCarTag/postCarTag';
import { UserDetailsFormSchema } from 'entities/User/types/UserDetailsFormSchema';
import { UserPerformedCarTag } from 'entities/User/types/UserPerformedCarTag';

export async function postCarAssignTag(
    userId: string,
    formData: UserDetailsFormSchema,
    performedCarTag: Optional<UserPerformedCarTag>,
) {
    if (formData?.car && !performedCarTag?.object_info) {
        return postCarTag({
            car_id: formData.car.id,
            tag: 'assigned_to_operator',
            performer: userId,
        });
    }

    if (!formData?.car && performedCarTag?.object_info) {
        return deleteCarTag(performedCarTag.tag_id);
    }
}
