import { postCarAssignTag } from 'features/UserDetails/api/postCarAssignTag/postCarAssignTag';

import { postUser } from 'entities/User';
import { UserDetailsFormSchema } from 'entities/User/types/UserDetailsFormSchema';
import { UserPerformedCarTag } from 'entities/User/types/UserPerformedCarTag';

export async function postUserEdit(
    userId: string,
    formData: UserDetailsFormSchema,
    performedCarTag: Optional<UserPerformedCarTag>,
) {
    await postCarAssignTag(userId, formData, performedCarTag);

    return postUser({ id: userId, ...formData });
}
