import { UserStatus } from 'entities/User/consts/UserStatus';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { ONE_MINUTE } from 'constants/constants';

export type PostUserStatus = UserStatus.ACTIVE | UserStatus.REJECTED | UserStatus.BLOCKED;

export interface PostUserStatusData {
    object_id: string;
    tag: string;
}

export interface PostUserSettingsRes {
    rental_approve_user_tag: string;
    rental_reject_user_tag: string;
    tag_name: string;
}

export interface PostUserSettingsServerRes {
    options: PostUserSettingsRes;
}

const STATUS_TAG: Record<PostUserStatus, string> = {
    [UserStatus.ACTIVE]: 'rental_approve_user_tag',
    [UserStatus.REJECTED]: 'rental_reject_user_tag',
    [UserStatus.BLOCKED]: 'rental_blocked',
};

export async function postUserStatus(id: string, status: PostUserStatus) {
    const settings = await fetchRequest<{}, PostUserSettingsRes, PostUserSettingsServerRes>(
        '/api/leasing/settings/list',
        {},
        { parser: (res) => res.options },
    );

    const statusTag = STATUS_TAG[status];

    return fetchRequest<PostUserStatusData, unknown>(
        '/api/yandex/tag/evolve',
        {
            object_id: id,
            tag: status === UserStatus.BLOCKED ? statusTag : settings[statusTag],
        },
        {
            method: 'POST',
            timeout: ONE_MINUTE,
        },
    );
}
