import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Block user': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Block user',
        ru: 'Заблокировать',
        cs: 'Blokovat uživatele',
    },
    'Block user?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Block user?',
        ru: 'Заблокировать пользователя?',
        cs: 'Zablokovat uživatele?',
    },
    Cancel: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cancel',
        ru: 'Отменить',
        cs: 'Zrušit',
    },
    'The user will get access to the application': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The user will get access to the application',
        ru: 'Пользователь получит доступ к приложению',
        cs: 'Uživatel získá přístup k aplikaci',
    },
    'The user will not be able to use the application': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The user will not be able to use the application',
        ru: 'Пользователь не сможет пользоваться приложением',
        cs: 'Uživatel nebude moci aplikaci používat',
    },
    'Unblock user': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Unblock user',
        ru: 'Разблокировать',
        cs: 'Odblokovat uživatele',
    },
    'Unblock user?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Unblock user?',
        ru: 'Разблокировать пользователя?',
        cs: 'Odblokovat uživatele?',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
