import * as React from 'react';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { Button } from 'shared/ui/Button/Button';
import { DialogContainer, DialogContainerProps } from 'shared/ui/DialogContainer/DialogContainer';

import { i18n } from 'features/UserDetails/ui/UserBlockDialog/UserBlockDialog.i18n';

import BanIcon from 'shared/ui/Icons/images/ban-16.inline.svg';

export interface UserBlockDialogProps extends Pick<DialogContainerProps, 'onClose'> {
    unblock?: boolean;

    onDialogSubmit(): void;
}

export const UserBlockDialog: React.FC<UserBlockDialogProps> = React.memo(function UserBlockDialog({
    unblock,
    onDialogSubmit,
    onClose,
}) {
    return (
        <DialogContainer
            title={unblock ? i18n('Unblock user?') : i18n('Block user?')}
            description={
                unblock
                    ? i18n('The user will get access to the application')
                    : i18n('The user will not be able to use the application')
            }
            hasClose
            controls={
                <>
                    <Button
                        color={unblock ? ButtonColor.PRIMARY : ButtonColor.ALARM}
                        size={ButtonSize.M}
                        icon={BanIcon}
                        label={unblock ? i18n('Unblock user') : i18n('Block user')}
                        onClick={onDialogSubmit}
                    />

                    <Button
                        color={ButtonColor.SECONDARY}
                        size={ButtonSize.M}
                        label={i18n('Cancel')}
                        onClick={onClose}
                    />
                </>
            }
            onClose={onClose}
        />
    );
});
