import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Add a user': {
        en: 'Add a user',
        ru: 'Добавить пользователя',
        cs: '',
    },
    'Add user': {
        en: 'Add user',
        ru: 'Добавить пользователя',
        cs: '',
    },
    'User with this phone number already exists': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'User with this phone number already exists',
        ru: 'Есть пользователь с таким номером телефона',
        cs: 'Uživatel s tímto telefonním číslem již existuje',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
