import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { UserCreateModal, UserCreateModalProps } from 'features/UserDetails/ui/UserCreateModal/UserCreateModal';

const storybookMeta = createStorybookMeta<UserCreateModalProps>({
    title: 'features/UserCreateModal',
    component: UserCreateModal,

    hermioneSelector: '[role="dialog"]',

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<UserCreateModalProps>(UserCreateModal);

export const normal = Template.bind({});
