import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Cancel: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cancel',
        ru: 'Отменить',
        cs: 'Zrušit',
    },
    Delete: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Delete',
        ru: 'Удалить',
        cs: 'Odstranit',
    },
    'Delete user?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Delete user?',
        ru: 'Удалить пользователя?',
        cs: 'Odstranit uživatele?',
    },
    'It can’t be undone': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'It can’t be undone',
        ru: 'Это не может быть отменено',
        cs: 'Tuto akci nelze vrátit zpět',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
