import * as React from 'react';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { Button } from 'shared/ui/Button/Button';
import { DialogContainer, DialogContainerProps } from 'shared/ui/DialogContainer/DialogContainer';

import { i18n } from 'features/UserDetails/ui/UserDeleteDialog/UserDeleteDialog.i18n';

import TrashIcon from 'shared/ui/Icons/images/trash-outline-16.inline.svg';

export interface UserDeleteDialogProps extends Pick<DialogContainerProps, 'onClose'> {
    onDialogSubmit(): void;
}

export const UserDeleteDialog: React.FC<UserDeleteDialogProps> = React.memo(function UserDeleteDialog({
    onDialogSubmit,
    onClose,
}) {
    return (
        <DialogContainer
            title={i18n('Delete user?')}
            description={i18n('It can\u2019t be undone')}
            hasClose
            controls={
                <>
                    <Button
                        color={ButtonColor.ALARM}
                        size={ButtonSize.M}
                        icon={TrashIcon}
                        label={i18n('Delete')}
                        onClick={onDialogSubmit}
                    />

                    <Button
                        color={ButtonColor.SECONDARY}
                        size={ButtonSize.M}
                        label={i18n('Cancel')}
                        onClick={onClose}
                    />
                </>
            }
            onClose={onClose}
        />
    );
});
