import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { UserDetails, UserDetailsProps } from 'features/UserDetails/ui/UserDetails/UserDetails';

import { useUserMember } from 'entities/User';
import { useUser } from 'entities/User/api/useUser/useUser';
import { useUserPerformedTags } from 'entities/User/api/useUserPerformedTags/useUserPerformedTags';

const storybookMeta = createStorybookMeta<UserDetailsProps>({
    title: 'features/UserDetails',
    component: UserDetails,

    args: {
        storybookWidth: '600px',
    },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<UserDetailsProps & { id: string }>(({ id, ...otherProps }) => {
    const userResource = useUser(id);
    const userMemberResource = useUserMember(id);
    const performedTagsResource = useUserPerformedTags(id);

    return (
        <UserDetails
            {...otherProps}
            userResource={userResource}
            memberResource={userMemberResource}
            performedTagsResource={performedTagsResource}
        />
    );
});

export const active = Template.bind({});
active.args = { id: 'b5af26e5-b024-4c10-bec8-4cce8f042560' };

export const withAddress = Template.bind({});
withAddress.args = { id: 'b5af26e5-b024-4c10-bec8-4cce8f042560' };
withAddress.parameters = { flags: { user_details_address: true } };

export const screening = Template.bind({});
screening.args = { id: 'b5af26e5-b024-4c10-bec8-4cce8f042561' };

export const rejected = Template.bind({});
rejected.args = { id: 'b5af26e5-b024-4c10-bec8-4cce8f042562' };

export const blocked = Template.bind({});
blocked.args = { id: 'b5af26e5-b024-4c10-bec8-4cce8f042563' };

export const assignedCar = Template.bind({});
assignedCar.args = { id: 'ecbfbdc2-6694-4b30-b85f-0536db21384a' };
assignedCar.parameters = { flags: { enableCarAssignment: true } };
