import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Address: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Address',
        ru: 'Адрес',
        cs: 'Adresa',
    },
    Car: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car',
        ru: 'Машина',
        cs: 'Vůz',
    },
    'Car model or licence plate number': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car model or licence plate number',
        ru: 'Модель автомобиля или регистрационный номер',
        cs: 'Model vozu nebo číslo registrační značky',
    },
    'Contact information': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Contact information',
        ru: 'Контактная информация',
        cs: 'Kontaktní údaje',
    },
    'E-mail': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'E-mail',
        ru: 'E-mail',
        cs: 'E-mail',
    },
    'Enter name': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enter name',
        ru: 'Введите имя',
        cs: 'Zadejte jméno',
    },
    'Enter surname': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enter surname',
        ru: 'Введите фамилию',
        cs: 'Zadejte příjmení',
    },
    Name: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Name',
        ru: 'Имя',
        cs: 'Jméno',
    },
    'Personal data': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Personal data',
        ru: 'Личные данные',
        cs: 'Osobní údaje',
    },
    Phone: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Phone',
        ru: 'Телефон',
        cs: 'Telefon',
    },
    Role: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Role',
        ru: 'Роль',
        cs: 'Role',
    },
    Surname: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Surname',
        ru: 'Фамилия',
        cs: 'Příjmení',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
