import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { UserDetailsForm, UserDetailsFormProps } from 'features/UserDetails/ui/UserDetailsForm/UserDetailsForm';

const storybookMeta = createStorybookMeta<UserDetailsFormProps>({
    title: 'features/UserDetails/UserDetailsForm',
    component: UserDetailsForm,

    parameters: {
        backgrounds: { default: 'white' },
    },

    args: {
        storybookWidth: '560px',
    },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<UserDetailsFormProps>(UserDetailsForm);

export const normal = Template.bind({});

export const withAddress = Template.bind({});
withAddress.parameters = { flags: { user_details_address: true } };

export const withRole = Template.bind({});
withRole.args = {
    roleInputValues: [{ value: 'admin', label: 'admin' }],
};

export const withCar = Template.bind({});
withCar.parameters = { flags: { enableCarAssignment: true } };
withCar.args = { showCarInput: true };

export const filled = Template.bind({});
filled.args = {
    initial: {
        first_name: 'Aleksey',
        last_name: 'Cherenkevich',
        phone: '+375336188394',
        email: 'cherenkevich.com@gmail.com',
        car: { model_name: 'Audi Q3 Quattro', number: 'f483ср799' },
    },
    showCarInput: true,
};
filled.parameters = { flags: { enableCarAssignment: true } };
