import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { UserEditModal, UserEditModalProps } from 'features/UserDetails/ui/UserEditModal/UserEditModal';

import { useUser } from 'entities/User/api/useUser/useUser';
import { useUserPerformedTags } from 'entities/User/api/useUserPerformedTags/useUserPerformedTags';

const storybookMeta = createStorybookMeta<UserEditModalProps>({
    title: 'features/UserDetails/UserEditModal',
    component: UserEditModal,

    hermioneSelector: '[role="dialog"]',

    args: {
        id: '1a4de6d7-bef1-4e35-a3ff-46b93f101f03',
    } as UserEditModalProps & { id: string },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<UserEditModalProps & { id: string }>(({ id, ...otherProps }) => {
    const userResource = useUser(id);
    const performedTagsResource = useUserPerformedTags(id);

    return (
        <UserEditModal
            {...otherProps}
            userResource={userResource}
            performedTagsResource={performedTagsResource}
        />
    );
});

export const normal = Template.bind({});
normal.parameters = { flags: { enableCarAssignment: true } };
normal.hermioneFn = async function (browser, selector) {
    await browser.$('[placeholder="Name"]').setValue(' ');
    await browser.$('[placeholder="Surname"]').setValue(' ');
    await browser.$('[placeholder="Phone"]').setValue('+375');
    await browser.$('[placeholder="E-mail"]').setValue('test');
    await browser.assertView('edited', selector);

    await browser.$('[placeholder="Car model or licence plate number"]').click();
    await browser.assertView('openedCarList', selector);

    await browser.$('li[role="option"]:nth-child(2)').click();
    await browser.assertView('withSelectedCar', selector);

    await browser.$('[title="Save changes"]').click();

    return browser.assertView('withError', selector);
};
