import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    UserDocumentDetails,
    UserDocumentDetailsProps,
} from 'features/UserDocuments/ui/UserDocumentDetails/UserDocumentDetails';

const storybookMeta = createStorybookMeta<UserDocumentDetailsProps>({
    title: 'features/UserDocuments/UserDocumentDetails',
    component: UserDocumentDetails,

    parameters: {
        backgrounds: { default: 'white' },
    },

    args: {
        storybookWidth: '968px',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<UserDocumentDetailsProps>(UserDocumentDetails);

export const normal = Template.bind({});
normal.args = {
    items: [
        { label: 'Surname', value: 'LEON' },
        { label: 'Name', value: 'FINKELSTEIN' },
        { label: 'Patronymic', value: 'RALEY' },
        { label: 'Country', value: 'USA' },
        { label: 'Registration country', value: 'USA' },
        { label: 'Passport series', value: 'MP' },
        { label: 'Passport number', value: '4234234' },
        { label: 'Issue date', value: '13 Feb 2019' },
        { label: 'Expire date', value: '13 Feb 2029' },
        { label: 'Sex', value: 'Male' },
        { label: 'Date of birth', value: '1 Jan 1988' },
        { label: 'Age', value: '34' },
        { label: 'Place of birth', value: 'WI' },
        { label: 'Place of residence', value: 'Wausau, WI 54403, 4806 Mercer Street' },
        { label: 'Registration till', value: '' },
    ],
};

export const empty = Template.bind({});
empty.hermioneSelector = 'html';
