import * as React from 'react';
import cn from 'classnames';

import { EMPTY_DATA } from 'constants/constants';

import styles from 'features/UserDocuments/ui/UserDocumentDetails/UserDocumentDetails.css';

export interface UserDocumentDetailsItem {
    label: string;
    value: Optional<string>;
}

export interface UserDocumentDetailsProps {
    className?: string;
    items?: UserDocumentDetailsItem[];
}

export const UserDocumentDetails: React.FC<UserDocumentDetailsProps> = React.memo(function UserDocumentDetails({
    className,
    items,
}) {
    if (!items || !items.length) {
        return null;
    }

    return (
        <ul className={cn(styles.details, className)}>
            {items.map(({ label, value }, index) => (
                <li
                    className={styles.item}
                    key={index}
                >
                    <p className={styles.label}>{label ?? EMPTY_DATA}</p>

                    <p className={styles.value}>{value?.length ? value : EMPTY_DATA}</p>
                </li>
            ))}
        </ul>
    );
});
