import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Driver license': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Driver license',
        ru: 'Водительские права',
        cs: 'Řidičský průkaz',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
