import * as React from 'react';
import cn from 'classnames';

import { UserDocumentPreviewItem } from 'features/UserDocuments/ui/UserDocumentPreviewItem/UserDocumentPreviewItem';

import { getUserDocumentPhotoData, UseUserDocumentPhotoRes } from 'entities/User';

import styles from 'features/UserDocuments/ui/UserDocumentPreview/UserDocumentPreview.css';

export interface UserDocumentPreviewProps {
    className?: string;
    photos: UseUserDocumentPhotoRes;
}

export const UserDocumentPreview: React.FC<UserDocumentPreviewProps> = React.memo(function UserDocumentPreview({
    className,
    photos,
}) {
    const items = getUserDocumentPhotoData(photos);

    return (
        <div className={cn(styles.list, className)}>
            {items.map((item) => (
                <UserDocumentPreviewItem
                    {...item}
                    key={item.type}
                />
            ))}
        </div>
    );
});
