import * as React from 'react';
import cn from 'classnames/bind';

import { getI18nLocale } from 'utils/language/getI18nLocale';

import { DocumentPhotoDataRes, useUserDocumentPhoto } from 'entities/User';
import { UserPhotoContentTypeSchema } from 'entities/User/types/UserPhotosSchema';

import { getDateString } from 'shared/helpers/getDateString/getDateString';
import { ImagesPreviewUpload } from 'shared/ui/ImagesPreviewUpload/ImagesPreviewUpload';
import { PictureOptions } from 'shared/ui/Picture/Picture';

import { i18n } from 'features/UserDocuments/ui/UserDocumentPreviewItem/UserDocumentPreviewItem.i18n';

import styles from 'features/UserDocuments/ui/UserDocumentPreviewItem/UserDocumentPreviewItem.css';

export interface UserDocumentPreviewItemProps extends DocumentPhotoDataRes {
    className?: string;
}

const cx = cn.bind(styles);

export const UserDocumentPreviewItem: React.FC<UserDocumentPreviewItemProps> = React.memo(
    function UserDocumentPreviewItem({ className, type, userId, photoId, date }) {
        const { data, isLoading } = useUserDocumentPhoto(userId, photoId);

        const locale = getI18nLocale();

        const typeLabel = React.useMemo(
            (): Record<UserPhotoContentTypeSchema, string> => ({
                lb: i18n('Back'),
                lf: i18n('Front'),
                pb: i18n('Page with photo'),
                ps: i18n('Selfie'),
            }),

            [],
        );

        const label = typeLabel[type];

        const items: PictureOptions[] = React.useMemo(() => [{ src: data, title: label }], [data, label]);

        return (
            <ImagesPreviewUpload
                className={cx(styles.item, { empty: !data && !isLoading }, [className])}
                images={items}
                isLoading={isLoading}
            >
                <div className={styles.info}>
                    <h5 className={styles.label}>{label}</h5>

                    <p className={styles.description}>
                        {date
                            ? getDateString(date, locale, {
                                  day: 'numeric',
                                  month: 'short',
                                  year: 'numeric',
                              })
                            : i18n('Missing')}
                    </p>
                </div>
            </ImagesPreviewUpload>
        );
    },
);
