import * as React from 'react';
import { useParams } from 'react-router-dom';
import cn from 'classnames';

import { UserDocumentDriverLicense } from 'features/UserDocuments/ui/UserDocumentDriverLicense/UserDocumentDriverLicense';
import { UserDocumentPassport } from 'features/UserDocuments/ui/UserDocumentPassport/UserDocumentPassport';

import { useUser } from 'entities/User/api/useUser/useUser';

import styles from 'features/UserDocuments/ui/UserDocuments/UserDocuments.css';

export interface UserDocumentsProps {
    className?: string;
}

// @todo: add storybook test
export const UserDocuments: React.FC<UserDocumentsProps> = function UserDocuments({ className }) {
    const { id } = useParams<{ id: string }>();

    const userResource = useUser(id);

    return (
        <div className={cn(styles.content, className)}>
            <UserDocumentPassport resource={userResource} />

            <UserDocumentDriverLicense resource={userResource} />
        </div>
    );
};
