import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Added {date}': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Added {date}',
        ru: 'Добавлено {date}',
        cs: 'Přidáno {date}',
    },
    'Edit data': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Edit data',
        ru: 'Редактировать данные',
        cs: 'Upravit data',
    },
    'Last update {date}': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Last update {date}',
        ru: 'Обновлено {date}',
        cs: 'Poslední aktualizace {date}',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
