import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { minWidthState } from 'tests/storybook/helpers/minWidthState';

import {
    UserDocumentsItem,
    UserDocumentsItemProps,
} from 'features/UserDocuments/ui/UserDocumentsItem/UserDocumentsItem';

const storybookMeta = createStorybookMeta<UserDocumentsItemProps>({
    title: 'features/UserDocuments/UserDocumentsItem',
    component: UserDocumentsItem,

    args: {
        storybookWidth: '100vw',

        title: 'Passport',
        photos: { pb: {}, ps: {} },
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<UserDocumentsItemProps>(UserDocumentsItem);

// @todo: add photos case
export const normal = Template.bind({});
normal.args = {
    submittedAt: new Date('2021-10-22'),
    updatedAt: new Date('2022-01-22'),
    details: [
        { label: 'Surname', value: 'LEON' },
        { label: 'Name', value: 'FINKELSTEIN' },
        { label: 'Patronymic', value: 'RALEY' },
        { label: 'Country', value: 'USA' },
        { label: 'Registration country', value: 'USA' },
        { label: 'Passport series', value: 'MP' },
        { label: 'Passport number', value: '4234234' },
        { label: 'Issue date', value: '13 Feb 2019' },
        { label: 'Expire date', value: '13 Feb 2029' },
        { label: 'Sex', value: 'Male' },
        { label: 'Date of birth', value: '1 Jan 1988' },
        { label: 'Age', value: '34' },
        { label: 'Place of birth', value: 'WI' },
        { label: 'Place of residence', value: 'Wausau, WI 54403, 4806 Mercer Street' },
        { label: 'Registration till', value: '' },
    ],
    onEdit: () => {},
};
normal.hermioneFn = minWidthState;

export const empty = Template.bind({});
empty.hermioneFn = minWidthState;
