import * as React from 'react';

import {
    UserEditDocumentModal,
    UserEditDocumentModalProps,
} from 'features/UserDocuments/ui/UserEditDocumentModal/UserEditDocumentModal';

import { postUser, UserDocumentDriverLicenseForm, UseUserResource } from 'entities/User';
import { UserDrivingLicenseFormSchema } from 'entities/User/types/UserDrivingLicenseFormSchema';

import { getFetchErrorMessage } from 'shared/helpers/getFetchErrorMessage/getFetchErrorMessage';
import { useEqualDataForm } from 'shared/hooks/useEqualDataForm/useEqualDataForm';
import { useFormController } from 'shared/hooks/useFormController/useFormController';

export interface UserEditDocumentDriverLicenseModalProps extends Pick<UserEditDocumentModalProps, 'onClose'> {
    resource: UseUserResource;
}

// @todo: add storybook test
export const UserEditDocumentDriverLicenseModal: React.FC<UserEditDocumentDriverLicenseModalProps> =
    function UserEditDocumentDriverLicenseModal({ resource, onClose }) {
        const { getValues, validate, setError, controller } =
            useFormController<OptionalRecord<UserDrivingLicenseFormSchema>>();

        const documentsResource = resource.read();

        const { id, photos, documents } = documentsResource;

        const initForm = documents?.driving_license;

        const onSubmitHandler = React.useCallback(async () => {
            if (validate()) {
                const data = getValues();

                try {
                    await postUser({ id, driving_license: data as UserDrivingLicenseFormSchema });

                    // @todo: add notification
                } catch (error) {
                    return setError('_serverError', getFetchErrorMessage(error));
                }

                resource.reload();

                if (onClose) {
                    onClose();
                }
            }
        }, [onClose, getValues, validate, setError, resource, id]);

        const { isEqualData, onFormChangeHandler } = useEqualDataForm<UserDrivingLicenseFormSchema>(initForm);

        return (
            <UserEditDocumentModal
                photos={photos.driving_license}
                onClose={onClose}
                onSubmit={isEqualData ? undefined : onSubmitHandler}
            >
                <UserDocumentDriverLicenseForm
                    initial={initForm}
                    controller={controller}
                    onFormChange={onFormChangeHandler}
                />
            </UserEditDocumentModal>
        );
    };
