import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    UserEditDocumentModal,
    UserEditDocumentModalProps,
} from 'features/UserDocuments/ui/UserEditDocumentModal/UserEditDocumentModal';

const storybookMeta = createStorybookMeta<UserEditDocumentModalProps>({
    title: 'features/UserDocuments/UserEditDocumentModal',
    component: UserEditDocumentModal,

    hermioneSelector: '[role="dialog"]',

    args: {
        children: <div style={{ height: '1000px', backgroundColor: 'pink' }} />,
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<UserEditDocumentModalProps>(UserEditDocumentModal);

export const normal = Template.bind({});
normal.args = { photos: { pb: {}, ps: {} } };

export const empty = Template.bind({});
empty.args = { photos: {} };
