import * as React from 'react';
import cn from 'classnames';

import { DocumentPhotoDataRes, useUserDocumentPhoto } from 'entities/User';

import { Picture } from 'shared/ui/Picture/Picture';

import styles from 'features/UserDocuments/ui/UserEditDocumentModalPicture/UserEditDocumentModalPicture.css';

export interface UserEditDocumentModalPictureProps extends DocumentPhotoDataRes {
    className?: string;
}

// @todo: add storybook test
export const UserEditDocumentModalPicture: React.FC<UserEditDocumentModalPictureProps> =
    function UserEditDocumentModalPicture({ className, userId, photoId }) {
        const { data, isLoading } = useUserDocumentPhoto(userId, photoId);

        return (
            <Picture
                className={cn(styles.picture, className)}
                isLoading={isLoading}
                src={data}
                title=""
            />
        );
    };
