import * as React from 'react';

import {
    UserEditDocumentModal,
    UserEditDocumentModalProps,
} from 'features/UserDocuments/ui/UserEditDocumentModal/UserEditDocumentModal';

import { postUser, UserDocumentPassportForm, UseUserResource } from 'entities/User';
import { UserPassportFormSchema } from 'entities/User/types/UserPassportFormSchema';

import { getFetchErrorMessage } from 'shared/helpers/getFetchErrorMessage/getFetchErrorMessage';
import { useEqualDataForm } from 'shared/hooks/useEqualDataForm/useEqualDataForm';
import { useFormController } from 'shared/hooks/useFormController/useFormController';

export interface UserEditDocumentPassportModalProps extends Pick<UserEditDocumentModalProps, 'onClose'> {
    resource: UseUserResource;
}

// @todo: add storybook test
export const UserEditDocumentPassportModal: React.FC<UserEditDocumentPassportModalProps> =
    function UserEditDocumentPassportModal({ resource, onClose }) {
        const { getValues, validate, setError, controller } =
            useFormController<OptionalRecord<UserPassportFormSchema>>();

        const documentsResource = resource.read();

        const { id, photos, documents } = documentsResource;

        const initForm = documents?.passport;

        const onSubmitHandler = React.useCallback(async () => {
            if (validate()) {
                const data = getValues();

                try {
                    await postUser({ id, passport: data as UserPassportFormSchema });

                    // @todo: add notification
                } catch (error) {
                    return setError('_serverError', getFetchErrorMessage(error));
                }

                resource.reload();

                if (onClose) {
                    onClose();
                }
            }
        }, [onClose, getValues, validate, setError, resource, id]);

        const { isEqualData, onFormChangeHandler } = useEqualDataForm<UserPassportFormSchema>(initForm);

        return (
            <UserEditDocumentModal
                photos={photos.passport}
                onClose={onClose}
                onSubmit={isEqualData ? undefined : onSubmitHandler}
            >
                <UserDocumentPassportForm
                    initial={initForm}
                    controller={controller}
                    onFormChange={onFormChangeHandler}
                />
            </UserEditDocumentModal>
        );
    };
