import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    UserOrganizationTags,
    UserOrganizationTagsProps,
} from 'features/UserOrganizationTags/ui/UserOrganizationTags/UserOrganizationTags';

const storybookMeta = createStorybookMeta<UserOrganizationTagsProps>({
    title: 'features/UserOrganizationTags',
    component: UserOrganizationTags,

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<UserOrganizationTagsProps>(UserOrganizationTags);

export const withoutTags = Template.bind({});
withoutTags.args = {
    userId: '4cbfbdc2-6694-4b30-b85f-0536db21384a',
};

export const normal = Template.bind({});
normal.args = {
    userId: 'ecbfbdc2-6694-4b30-b85f-0536db21384a',
};

normal.hermioneFn = async (browser, selector) => {
    const select = '[data-testid="affiliationTags"]';
    const menuEl = '[role="menu"]';
    const clearIcon = '[role="button"]';

    await browser.$(select).click();
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('opened', [selector, select, menuEl]);

    await browser.$(clearIcon).click();
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('withTags', [selector, select, menuEl]);

    await browser.$('li[role="option"]:first-child').click();
    await browser.$(menuEl).waitForDisplayed({ reverse: true });
    await browser.assertView('withAnotherTag', [selector, select]);
};
