import * as React from 'react';

/**
 * @deprecated Use useClickOutside instead
 */
export const useOutsideClickHandler = (ref, handler) => {
    React.useEffect(() => {
        let handleClickOutside = (event) => {
            if (ref.current && !ref.current.contains(event.target)) {
                handler(event);
            }
        };

        document.addEventListener('mousedown', handleClickOutside);

        return () => {
            document.removeEventListener('mousedown', handleClickOutside);
        };
    }, [ref]);
};
