import * as React from 'react';

import { RequestHelper } from '../../request-helper/src';

interface IRequestOptions {
    requestName: string;
    requestOptions: { [key: string]: unknown };
}

export function useRequestHandler<T>(
    request: RequestHelper,
    options: IRequestOptions,
    responseHandler?: (_res) => T | null,
): [boolean, T | null, Error | null, () => void] {
    let [isLoading, setLoading] = React.useState(false);
    let [response, setResponse] = React.useState<T | null>(null);
    let [error, setError] = React.useState<Error | null>(null);
    let [requestShouldFire, fireRequest] = React.useState<boolean>(false);

    React.useEffect(() => {
        if (options && requestShouldFire) {
            setLoading(true);
            setError(null);
            const fetchData = async () => {
                try {
                    let _response = await request.exec(options.requestName, {
                        ...options.requestOptions,
                    });
                    if (responseHandler) {
                        await setResponse(responseHandler(_response));
                    } else {
                        await setResponse(_response);
                    }
                } catch (e) {
                    setError(e);
                }
            };

            fetchData().then(() => {
                setLoading(false);
                fireRequest(false);
            });
        }

        return () => {
            request.abort();
        };
    }, [requestShouldFire]);

    return [
        isLoading,
        response,
        error,
        () => {
            fireRequest(true);
        },
    ];
}
